define(['app', 'angular'], function (app, angular) {
	app.directive('listTable', function () {
		return {
			restrict: 'AE',
			scope: {
				'listItems' : '=',
				'headers' : '=',
				'rows' : '=',
				'onItemClick' : '&',
                'resultsMessage' : '=',
				'noResultsMessage' : '=',
				'noUnfilteredResultsTemplate' : '=',
				'unfilteredItemCount': '=',
				'ordering': '=',
				'includeArrow': '='
			},
			controller : function($scope, $parse){
				$scope.getDeepObjectValue = function(item, header) {
					var val = $parse(header.keys)(item);
					if(!angular.isUndefined(header.ifNull)) {
						return val || header.ifNull;
					}
					return val;
				};

				$scope.isValueNull = function(item, header) {
					var value = $scope.getDeepObjectValue(item, header);
					return !(value || value === 0);
				};
			},
			templateUrl: function(elem, attr) {
				return attr.useCellPartials ? 'src/ui-components/table/table-with-cell-partials_template.html' : 'src/ui-components/table/table_template.html';
			}
		};
	});
});